;; | -----------------------------------------------------------------------------------
;; | MI_GetLoadedMenus (New in V7)
;; | -----------------------------------------------------------------------------------
;; | Function  : Returns a list of all loaded menus
;; | Arguments : (none)
;; | Return    : A list of all menu group names
;; | Updated   : December 16, 2015
;; | Comments  : (none)
;; | e-mail    : rakesh.rao@thedesignsense.com 
;; | Web       : www.thedesignsense.com
;; | -----------------------------------------------------------------------------------

(defun MI_GetLoadedMenus ( / objApp objMenuGroup objMenuGroups mnuLst )

(setq
	objApp        (vlax-get-acad-object)
	objMenuGroups (vla-get-MenuGroups objApp)
	mnuLst        '()
)

(vlax-for objMenuGroup objMenuGroups
	(setq mnuLst (cons (strcase (vla-get-Name objMenuGroup)) mnuLst))
)

(setq mnuLst (reverse mnuLst))
)


;; | -----------------------------------------------------------------------------------
;; | MI_LoadPartialMenu2 (New in V7)
;; | -----------------------------------------------------------------------------------
;; | Function  : Load a partial menu using ActiveX functions
;; | Arguments : mnuName - Menugroup name
;; | Return    : (none)
;; | Updated   : December 16, 2015
;; | Comments  : (none)
;; | e-mail    : rakesh.rao@thedesignsense.com 
;; | Web       : www.thedesignsense.com
;; | ----------------------------------------------------------------------------------

(defun MI_LoadPartialMenu2 ( mnuName / mnuLst objApp objDOC objMenuGroups tmp fn )

(setq
	mnuName       (strcase mnuName)

	mnuLst        (MI_GetLoadedMenus)

	objApp        (vlax-get-acad-object)
	objDOC        (vla-get-activedocument objApp)
	objMenuGroups (vla-get-MenuGroups objApp)
)

(if (not (member mnuName mnuLst))
(progn
	(setq tmp nil)

	(cond
		((= #Caller "CADPower")
			(if #AppDir_CP
				(setq tmp #AppDir_CP)
				(setq tmp "")
			)
		)
		((= #Caller "GeoTools")
			(if #AppDir_GT
				(setq tmp #AppDir_GT)
				(setq tmp "")
			)
		)
		(T
			(setq tmp "")
		)
	)

	(setq fn nil)

	(if (not (setq fn (findfile (strcat tmp mnuName ".cuix"))))
	(progn
		(if (not (setq fn (findfile (strcat tmp mnuName ".cui"))))
		(progn
			(if (not (setq fn (findfile (strcat tmp mnuName ".mnu"))))
				(prin1)
			)
		))
	))

	(if fn
	(progn
		(vla-load objMenuGroups fn)
		(setq
			tmp (strcat "P30=+" mnuName ".pop1")
			tmp (menucmd tmp)
		)
	))
)
(princ (strcat "\n" mnuName " already loaded."))
)
)

;; | ---------------------------------------------------------------------------
;; | CP_Load
;; | ---------------------------------------------------------------------------
;; | Function : Load the CADPower software program and the menu
;; | Argument : None
;; | Return   : None
;; | Updated  : June 11, 1999
;; | ---------------------------------------------------------------------------

(defun C:CP_Load( / kwd )
(initget "Yes No")
(setq kwd (getkword "\nMchten Sie das CADPower Programm und das Men laden ? <Yes>:"))
(if (not kwd) (setq kwd "Yes"))
(if (= kwd "Yes")
	(CP_Load_DE)
)
(prin1)
)

(defun CP_Load_DE ( / tmp AcadVer )
(setq AcadVer (getvar "ACADVER"))
(cond
	((wcmatch AcadVer "*18.2*")
		(setq AcadVer 2012)
	)
	((wcmatch AcadVer "*19.0*")
		(setq AcadVer 2013)
	)
	((wcmatch AcadVer "*19.1*")
		(setq AcadVer 2014)
	)
	((wcmatch AcadVer "*20.0*")
		(setq AcadVer 2015)
	)
	((wcmatch AcadVer "*20.1*")
		(setq AcadVer 2016)
	)
	((wcmatch AcadVer "*21.0*")
		(setq AcadVer 2017)
	)
	((or (wcmatch AcadVer "*22.0*") (wcmatch AcadVer "*22.1*"))
		(setq AcadVer 2018)
	)
	((wcmatch AcadVer "*23.0*")
		(setq AcadVer 2019)
	)
	((wcmatch AcadVer "*23.1*")
		(setq AcadVer 2020)
	)
	((wcmatch AcadVer "*24.0*")
		(setq AcadVer 2021)
	)
	((wcmatch AcadVer "*24.1*")
		(setq AcadVer 2022)
	)
	((wcmatch AcadVer "*24.2*")
		(setq AcadVer 2023)
	)
	((wcmatch AcadVer "*24.3*")
		(setq AcadVer 2024)
	)
	((wcmatch AcadVer "*25.0*")
		(setq AcadVer 2025)
	)
	((wcmatch AcadVer "*25.1*")
		(setq AcadVer 2026)
	)
	(T
		(princ "\nWarnung: Diese Version von AutoCAD wird nicht untersttzt.")
	)
)

(if (findfile "CADPower.VLX")
(progn
	(if (not (member 'CADPOWER (vl-list-loaded-vlx)))
		(load "CADPower.VLX")
	)

	(setq #Caller "CADPower")
	(MI_LoadPartialMenu2 "CADPower_DE_2K12")
	(princ "\nGeben Sie den Befehl 'CP_AddUI' ein, falls das Men noch nicht geladen ist.")
)
(alert "Die Datei CADPower.VLX konnte nicht gefunden werden. berprfen Sie bitte die Installation.")
)

(setq tmp (getvar "MENUBAR"))
(if tmp
	(setvar "MENUBAR" 1)
)

; Load Lisp in every dwg document
(setvar "ACADLSPASDOC" 1)

(graphscr)
(princ "\nGeben Sie den Befehl 'CP_AddUI' ein, falls das Men noch nicht geladen ist.")
)

;; | ---------------------------------------------------------------------------
;; | CP_UnLoad
;; | ---------------------------------------------------------------------------
;; | Function : UnLoad the CADPower software program and the menu
;; | Argument : None
;; | Return   : None
;; | Updated  : June 11, 1999
;; | ---------------------------------------------------------------------------

(defun C:CP_UnLoad( / kwd )
(initget "Yes No")
(setq kwd (getkword "\nMchten Sie das CADPower-Men ausblenden und das Programm entfernen? <No>:"))
(if (not kwd) (setq kwd "No"))
(if (= kwd "Yes")
	(CP_UnLoad_DE)
)
(prin1)
)

(defun CP_UnLoad_DE ( / AcadVer )
(setq AcadVer (getvar "ACADVER"))
(cond
	((wcmatch AcadVer "*18.2*")
		(setq AcadVer 2012)
	)
	((wcmatch AcadVer "*19.0*")
		(setq AcadVer 2013)
	)
	((wcmatch AcadVer "*19.1*")
		(setq AcadVer 2014)
	)
	((wcmatch AcadVer "*20.0*")
		(setq AcadVer 2015)
	)
	((wcmatch AcadVer "*20.1*")
		(setq AcadVer 2016)
	)
	((wcmatch AcadVer "*21.0*")
		(setq AcadVer 2017)
	)
	((or (wcmatch AcadVer "*22.0*") (wcmatch AcadVer "*22.1*"))
		(setq AcadVer 2018)
	)
	((wcmatch AcadVer "*23.0*")
		(setq AcadVer 2019)
	)
	((wcmatch AcadVer "*23.1*")
		(setq AcadVer 2020)
	)
	((wcmatch AcadVer "*24.0*")
		(setq AcadVer 2021)
	)
	((wcmatch AcadVer "*24.1*")
		(setq AcadVer 2022)
	)
	((wcmatch AcadVer "*24.2*")
		(setq AcadVer 2023)
	)
	((wcmatch AcadVer "*24.3*")
		(setq AcadVer 2024)
	)
	((wcmatch AcadVer "*25.0*")
		(setq AcadVer 2025)
	)
	((wcmatch AcadVer "*25.1*")
		(setq AcadVer 2026)
	)
	(T
		(princ "\nWarnung: Diese Version von AutoCAD wird nicht untersttzt.")
	)
)

(if (member 'CADPOWER (vl-list-loaded-vlx))
	(vl-unload-vlx "CADPower")
)

(if (menugroup "CADPower_DE_2K12")
(progn
	(command "._MenuUnLoad" "CADPower_DE_2K12")
	(alert "CADPower Men wurde entfernt.")
))
)

(princ "\nGeben Sie den Befehl: CP_LOAD ein, um CADPower zu laden.")
(princ "\nGeben Sie den Befehl: CP_UNLOAD ein, um CADPower zu entfernen.")
(prin1)
