
;; | ---------------------------------------------------------------------------
;; | ACAD.LSP
;; | ---------------------------------------------------------------------------
;; | Function : Sample startup file for GeoTools
;; | Argument : None
;; | Return   : None
;; | Updated  : December 28, 2011
;; | ---------------------------------------------------------------------------

;; | ----------------------------------------------------------------------------
;; | MI_SetSupportPath
;; | ----------------------------------------------------------------------------
;; | Arguments: 'prfName' - Profile Name
;; |            'Path'    - Support Path to set
;; | Function : Sets the Support path for the specified profile
;; | Updated  : November 11, 2003
;; | e-mail   : rakesh.rao@4d-technologies.com 
;; | Web      : www.4d-technologies.com
;; | ----------------------------------------------------------------------------

(defun MI_SetSupportPath ( prfName Path / acPrfName acadApp prefObj filesObj )
(if (member (strcase prfName) (mapcar 'strcase (MI_GetAllProfiles)))
(progn
	(setq acPrfName (MI_GetActiveProfile))
	(MI_SetActiveProfile prfName)

	(setq
		acadApp   (vlax-get-acad-object)
		prefObj   (vla-get-Preferences acadApp)
		filesObj  (vla-get-Files prefObj)
	)
	(vla-put-SupportPath filesObj Path)
	(MI_SetActiveProfile acPrfName)
)
(alert (strcat "Profile name: " prfName " is not defined in the CAD setup."))
)
)

;; | ----------------------------------------------------------------------------
;; | MI_GetActiveProfile
;; | ----------------------------------------------------------------------------
;; | Arguments: (none)
;; | Function : Returns the current profile in use
;; | Updated  : November 11, 2003
;; | e-mail   : rakesh.rao@4d-technologies.com 
;; | Web      : www.4d-technologies.com
;; | ----------------------------------------------------------------------------

(defun MI_GetActiveProfile ( / acadApp prefObj cProfiles cProfile)

(if vla-get-ActiveProfile
	(setq
		acadApp   (vlax-get-acad-object)
		prefObj   (vla-get-Preferences acadApp)
		cProfiles (vla-get-Profiles prefObj)
		cProfile  (vla-get-ActiveProfile cProfiles)
	)
	(setq cProfile (getvar "CPROFILE"))
)

cProfile
)

;; | ----------------------------------------------------------------------------
;; | MI_GetAllProfiles
;; | ----------------------------------------------------------------------------
;; | Arguments: none
;; | Function : Returns a list string names of all the currently defined profiles
;; |            in the drawing
;; | Updated  : October 17, 2003
;; | e-mail   : rakesh.rao@4d-technologies.com 
;; | Web      : www.4d-technologies.com
;; | ----------------------------------------------------------------------------

(defun MI_GetAllProfiles( / profLst acadApp prefObj cProfiles pNames)
(setq
	acadApp   (vlax-get-acad-object)
	prefObj   (vla-get-Preferences acadApp)
	cProfiles (vla-get-Profiles prefObj)
)
(vlax-invoke-method cProfiles 'GetAllProfileNames 'pNames)
(setq profLst (vlax-safearray->list pNames))
)

;; | ----------------------------------------------------------------------------
;; | MI_SetActiveProfile
;; | ----------------------------------------------------------------------------
;; | Arguments: 'ProfileName' - Profile Name to set current
;; | Function : Set the specified profile as current
;; | Updated  : October 30, 2002
;; | e-mail   : rakesh.rao@4d-technologies.com 
;; | Web      : www.4d-technologies.com
;; | ----------------------------------------------------------------------------

(defun MI_SetActiveProfile ( ProfileName / acadApp prefObj cProfiles profLst )
(setq profLst (MI_GetAllProfiles))
(if profLst
(progn
	(setq profLst (mapcar 'strcase profLst))
	(if (member (strcase ProfileName) profLst)
	(progn
		(setq
			acadApp   (vlax-get-acad-object)
			prefObj   (vla-get-Preferences acadApp)
			cProfiles (vla-get-Profiles prefObj)
		)
		(vla-put-ActiveProfile cProfiles ProfileName)
	)
	(alert (strcat "Profile: " ProfileName "is not defined for the currently logged in CAD user."))
	)
))
)

;; | ----------------------------------------------------------------------------
;; | MI_GetSupportPath
;; | ----------------------------------------------------------------------------
;; | Arguments: 'prfName' - Profile Name
;; | Function : Gets the Support path for the specified profile
;; | Updated  : November 11, 2003
;; | e-mail   : rakesh.rao@4d-technologies.com 
;; | Web      : www.4d-technologies.com
;; | ----------------------------------------------------------------------------

(defun MI_GetSupportPath ( prfName / acPrfName acadApp prefObj filesObj Path )
(setq Path nil)
(if (member (strcase prfName) (mapcar 'strcase (MI_GetAllProfiles)))
(progn
	(setq acPrfName (MI_GetActiveProfile))
	(MI_SetActiveProfile prfName)

	(setq
		acadApp   (vlax-get-acad-object)
		prefObj   (vla-get-Preferences acadApp)
		filesObj  (vla-get-Files prefObj)
		Path      (vla-get-SupportPath filesObj)
	)
	(MI_SetActiveProfile acPrfName)
)
(alert (strcat "Profile name: " prfName " is not defined in the CAD setup."))
)
Path
)


(if (getvar "SECURELOAD")
	(setvar "SECURELOAD" 0)
)

(setq #ActiveProfile (MI_GetActiveProfile))

(if (findfile "CP_Load_DE.LSP")
(progn
	(load "CP_Load_DE")
	(CP_Load_DE)
))

(if (findfile "GT_Load_DE.LSP")
(progn
	(load "GT_Load_DE")
	(GT_Load_DE)
))

(princ "\nType CP_LOAD   to load   CADPower.")
(princ "\nType CP_UNLOAD to unload CADPower.")

(princ "\nType GT_LOAD   to load   GeoTools.")
(princ "\nType GT_UNLOAD to unload GeoTools.")

