;; | -----------------------------------------------------------------------------------
;; | MI_GetLoadedMenus (New in V7)
;; | -----------------------------------------------------------------------------------
;; | Function  : Returns a list of all loaded menus
;; | Arguments : (none)
;; | Return    : A list of all menu group names
;; | Updated   : December 16, 2015
;; | Comments  : (none)
;; | e-mail    : rakesh.rao@4d-technologies.com 
;; | Web       : www.4d-technologies.com
;; | -----------------------------------------------------------------------------------

(defun MI_GetLoadedMenus ( / objApp objMenuGroup objMenuGroups mnuLst )

(setq
	objApp        (vlax-get-acad-object)
	objMenuGroups (vla-get-MenuGroups objApp)
	mnuLst        '()
)

(vlax-for objMenuGroup objMenuGroups
	(setq mnuLst (cons (strcase (vla-get-Name objMenuGroup)) mnuLst))
)

(setq mnuLst (reverse mnuLst))
)


;; | -----------------------------------------------------------------------------------
;; | MI_LoadPartialMenu2 (New in V7)
;; | -----------------------------------------------------------------------------------
;; | Function  : Load a partial menu using ActiveX functions
;; | Arguments : mnuName - Menugroup name
;; | Return    : (none)
;; | Updated   : December 16, 2015
;; | Comments  : (none)
;; | e-mail    : rakesh.rao@4d-technologies.com 
;; | Web       : www.4d-technologies.com
;; | ----------------------------------------------------------------------------------

(defun MI_LoadPartialMenu2 ( mnuName / mnuLst objApp objDOC objMenuGroups tmp fn )

(setq
	mnuName       (strcase mnuName)

	mnuLst        (MI_GetLoadedMenus)

	objApp        (vlax-get-acad-object)
	objDOC        (vla-get-activedocument objApp)
	objMenuGroups (vla-get-MenuGroups objApp)
)

(if (not (member mnuName mnuLst))
(progn
	(setq tmp nil)

	(cond
		((= #Caller "CADPower")
			(if #AppDir_CP
				(setq tmp #AppDir_CP)
				(setq tmp "")
			)
		)
		((= #Caller "GeoTools")
			(if #AppDir_GT
				(setq tmp #AppDir_GT)
				(setq tmp "")
			)
		)
		(T
			(setq tmp "")
		)
	)

	(setq fn nil)

	(if (not (setq fn (findfile (strcat tmp mnuName ".cuix"))))
	(progn
		(if (not (setq fn (findfile (strcat tmp mnuName ".cui"))))
		(progn
			(if (not (setq fn (findfile (strcat tmp mnuName ".mnu"))))
				(prin1)
			)
		))
	))

	(if fn
	(progn
		(vla-load objMenuGroups fn)
		; RAO added 23.1.2019
		(setq
			tmp (strcat "P30=+" mnuName ".pop1")
			tmp (menucmd tmp)
		)
	))
)
(princ (strcat "\n" mnuName " already loaded."))
)
)


;; | ---------------------------------------------------------------------------
;; | GT_Load
;; | ---------------------------------------------------------------------------
;; | Function : Cargar el programa y el men de GeoTools
;; | Argument : None
;; | Return   : None
;; | Updated  : June 11, 1999
;; | ---------------------------------------------------------------------------

(defun C:GT_Load( / kwd )
(initget "Si No")
(setq kwd (getkword "\nDesea cargar los programas y mens de GeoTools? <Si>:"))
(if (not kwd) (setq kwd "Si"))
(if (= kwd "Si")
	(GT_Load_ES)
)
(prin1)
)

(defun GT_Load_ES ( / tmp AcadVer )
(setq AcadVer (getvar "ACADVER"))
(cond
	((wcmatch AcadVer "*18.2*")
		(setq AcadVer 2012)
	)
	((wcmatch AcadVer "*19.0*")
		(setq AcadVer 2013)
	)
	((wcmatch AcadVer "*19.1*")
		(setq AcadVer 2014)
	)
	((wcmatch AcadVer "*20.0*")
		(setq AcadVer 2015)
	)
	((wcmatch AcadVer "*20.1*")
		(setq AcadVer 2016)
	)
	((wcmatch AcadVer "*21.0*")
		(setq AcadVer 2017)
	)
	((or (wcmatch AcadVer "*22.0*") (wcmatch AcadVer "*22.1*"))
		(setq AcadVer 2018)
	)
	((wcmatch AcadVer "*23.0*")
		(setq AcadVer 2019)
	)
	((wcmatch AcadVer "*23.1*")
		(setq AcadVer 2020)
	)
	((wcmatch AcadVer "*24.0*")
		(setq AcadVer 2021)
	)
	((wcmatch AcadVer "*24.1*")
		(setq AcadVer 2022)
	)
	((wcmatch AcadVer "*24.2*")
		(setq AcadVer 2023)
	)
	((wcmatch AcadVer "*24.3*")
		(setq AcadVer 2024)
	)
	((wcmatch AcadVer "*25.0*")
		(setq AcadVer 2025)
	)
	((wcmatch AcadVer "*25.1*")
		(setq AcadVer 2026)
	)
	(T
		(princ "\nAVISO : Versin de AutoCAD no soportado.")
	)
)

(if (findfile "GeoTools.VLX")
(progn
	(if (not (member 'GEOTOOLS (vl-list-loaded-vlx)))
		(load "GeoTools.VLX")
	)

	(setq #Caller "GeoTools")
	(MI_LoadPartialMenu2 "GeoTools_ES_2K12")
	(princ "\nTeclee 'GT_AddUI' para cargar men de GeoTools si no ya cargado.")
)
(alert "No puede encontrar archivo ejecutable de GeoTools, 'GeoTools.VLX'. Por favor chequee su instalacin.")
)

(setq tmp (getvar "MENUBAR"))
(if tmp
	(setvar "MENUBAR" 1)
)

; Load Lisp in every dwg document
(setvar "ACADLSPASDOC" 1)

(graphscr)
(princ "\nTeclee 'GT_AddUI' para cargar men de GeoTools si no ya cargado.")
)

;; | ---------------------------------------------------------------------------
;; | GT_UnLoad
;; | ---------------------------------------------------------------------------
;; | Function : UnLoad the GeoTools software program and the menu
;; | Argument : None
;; | Return   : None
;; | Updated  : June 11, 1999
;; | ---------------------------------------------------------------------------

(defun C:GT_UnLoad( / kwd )
(initget "Si No")
(setq kwd (getkword "\nDo you wish to unload the GeoTools program and menu? <No>:"))
(if (not kwd) (setq kwd "No"))
(if (= kwd "Yes")
	(GT_UnLoad_ES)
)
(prin1)
)

(defun GT_UnLoad_ES ( / AcadVer )
(setq AcadVer (getvar "ACADVER"))
(cond
	((wcmatch AcadVer "*18.2*")
		(setq AcadVer 2012)
	)
	((wcmatch AcadVer "*19.0*")
		(setq AcadVer 2013)
	)
	((wcmatch AcadVer "*19.1*")
		(setq AcadVer 2014)
	)
	((wcmatch AcadVer "*20.0*")
		(setq AcadVer 2015)
	)
	((wcmatch AcadVer "*20.1*")
		(setq AcadVer 2016)
	)
	((wcmatch AcadVer "*21.0*")
		(setq AcadVer 2017)
	)
	((or (wcmatch AcadVer "*22.0*") (wcmatch AcadVer "*22.1*"))
		(setq AcadVer 2018)
	)
	((wcmatch AcadVer "*23.0*")
		(setq AcadVer 2019)
	)
	((wcmatch AcadVer "*23.1*")
		(setq AcadVer 2020)
	)
	((wcmatch AcadVer "*24.0*")
		(setq AcadVer 2021)
	)
	((wcmatch AcadVer "*24.1*")
		(setq AcadVer 2022)
	)
	((wcmatch AcadVer "*24.2*")
		(setq AcadVer 2023)
	)
	((wcmatch AcadVer "*24.3*")
		(setq AcadVer 2024)
	)
	((wcmatch AcadVer "*25.0*")
		(setq AcadVer 2025)
	)
	((wcmatch AcadVer "*25.1*")
		(setq AcadVer 2026)
	)
	(T
		(princ "\nAVISO : Versin de AutoCAD no soportado.")
	)
)

(if (member 'GEOTOOLS (vl-list-loaded-vlx))
	(vl-unload-vlx "GeoTools")
)

(if (menugroup "GeoTools_ES_2K12")
(progn
	(command "._MenuUnLoad" "GeoTools_ES_2K12")
	(alert "Men de GeoTools descargado con xito.")
))
)

(princ "\nTeclee GT_LOAD para cargar GeoTools.")
(princ "\nTeclee GT_UNLOAD para descargar GeoTools.")
(prin1)
