;; | -----------------------------------------------------------------------------------
;; | MI_GetLoadedMenus (New in V7)
;; | -----------------------------------------------------------------------------------
;; | Function  : Returns a list of all loaded menus
;; | Arguments : (none)
;; | Return    : A list of all menu group names
;; | Updated   : December 16, 2015
;; | Comments  : (none)
;; | e-mail    : rakesh.rao@4d-technologies.com 
;; | Web       : www.4d-technologies.com
;; | -----------------------------------------------------------------------------------

(defun MI_GetLoadedMenus ( / objApp objMenuGroup objMenuGroups mnuLst )

(setq
	objApp        (vlax-get-acad-object)
	objMenuGroups (vla-get-MenuGroups objApp)
	mnuLst        '()
)

(vlax-for objMenuGroup objMenuGroups
	(setq mnuLst (cons (strcase (vla-get-Name objMenuGroup)) mnuLst))
)

(setq mnuLst (reverse mnuLst))
)


;; | -----------------------------------------------------------------------------------
;; | MI_LoadPartialMenu2 (New in V7)
;; | -----------------------------------------------------------------------------------
;; | Function  : Load a partial menu using ActiveX functions
;; | Arguments : mnuName - Menugroup name
;; | Return    : (none)
;; | Updated   : December 16, 2015
;; | Comments  : (none)
;; | e-mail    : rakesh.rao@4d-technologies.com 
;; | Web       : www.4d-technologies.com
;; | ----------------------------------------------------------------------------------

(defun MI_LoadPartialMenu2 ( mnuName / mnuLst objApp objDOC objMenuGroups tmp fn )

(setq
	mnuName       (strcase mnuName)

	mnuLst        (MI_GetLoadedMenus)

	objApp        (vlax-get-acad-object)
	objDOC        (vla-get-activedocument objApp)
	objMenuGroups (vla-get-MenuGroups objApp)
)

(if (not (member mnuName mnuLst))
(progn
	(setq tmp nil)

	(cond
		((= #Caller "CADPower")
			(if #AppDir_CP
				(setq tmp #AppDir_CP)
				(setq tmp "")
			)
		)
		((= #Caller "GeoTools")
			(if #AppDir_GT
				(setq tmp #AppDir_GT)
				(setq tmp "")
			)
		)
		(T
			(setq tmp "")
		)
	)

	(setq fn nil)

	(if (not (setq fn (findfile (strcat tmp mnuName ".cuix"))))
	(progn
		(if (not (setq fn (findfile (strcat tmp mnuName ".cui"))))
		(progn
			(if (not (setq fn (findfile (strcat tmp mnuName ".mnu"))))
				(prin1)
			)
		))
	))

	(if fn
	(progn
		(vla-load objMenuGroups fn)
		(setq
			tmp (strcat "P30=+" mnuName ".pop1")
			tmp (menucmd tmp)
		)
	))
)
(princ (strcat "\n" mnuName " already loaded."))
)
)

;; | ---------------------------------------------------------------------------
;; | GT_Load
;; | ---------------------------------------------------------------------------
;; | Function : Load the GeoTools software program and the menu
;; | Argument : None
;; | Return   : None
;; | Updated  : June 11, 1999
;; | ---------------------------------------------------------------------------

(defun C:GT_Load ( / kwd )
(initget "Yes No")
(setq kwd (getkword "\nDo you wish to load GeoTools program and menu? <Yes>:"))
(if (not kwd) (setq kwd "Yes"))
(if (= kwd "Yes")
	(GT_Load_EN)
)
(prin1)
)

(defun GT_Load_EN ( / tmp )

(if (findfile "GeoTools_BC.DES")
(progn
	(load "GeoTools_BC.DES")

	(setq #Caller "GeoTools")
	(MI_LoadPartialMenu2 "GeoTools_EN")
	(princ "\nType 'GT_AddUI' to load GeoTools menu if not already loaded.")
)
(alert "Cannot find GeoTools executable file GeoTools_BC.DES. Please check you installation.")
)

(setq tmp (getvar "MENUBAR"))
(if tmp
	(setvar "MENUBAR" 1)
)

; Load Lisp in every dwg document
(setvar "ACADLSPASDOC" 1)

(graphscr)
(princ "\nType 'GT_AddUI' to load GeoTools menu if not already loaded.")
)

